package com.ejie.ab04b.control;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab04b.model.ApartadoAnexoI;
import com.ejie.ab04b.service.ApartadoAnexoIService;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0473s00Controller generated by UDA, 25-may-2017 9:36:38.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/apartadoAnexoI")
public class ApartadoAnexoIController {

	private static final Logger logger = LoggerFactory
			.getLogger(ApartadoAnexoIController.class);

	@Autowired
	private ApartadoAnexoIService apartadoAnexoIService;
	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  apdoanx073
	 *            String
	 *
	 * @param apdoanx073 the apdoanx 073
	 *  Ab0473s00 Objeto correspondiente al identificador indicado.
	 * @return the apartado anexo I
	 */
	@RequestMapping(value = "/{apdoanx073}", method = RequestMethod.GET)
	public @ResponseBody ApartadoAnexoI get(@PathVariable String apdoanx073) {
		ApartadoAnexoI apartadoAnexoI = new ApartadoAnexoI();
		apartadoAnexoI.setApdoanx073(apdoanx073);
		apartadoAnexoI = this.apartadoAnexoIService.find(apartadoAnexoI);
		ApartadoAnexoIController.logger
				.info("[GET - findBy_PK] : Obtener Ab0473s00 por PK");
		return apartadoAnexoI;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterAb0473s00
	 *            Ab0473s00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 *
	 * @param filterAb0473s00 the filter ab 0473 s 00
	 *  List<Ab0473s00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<ApartadoAnexoI> getAll(
			@ModelAttribute ApartadoAnexoI filterAb0473s00) {
		ApartadoAnexoIController.logger
				.info("[GET - find_ALL] : Obtener ApartadoAnexoI por filtro");
		return this.apartadoAnexoIService.findAll(filterAb0473s00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  apartadoAnexoI
	 *            the apartado anexo I
	 *
	 * @param apartadoAnexoI the apartado anexo I
	 *  Ab0473s00 Bean resultante de la modificacion.
	 * @return the apartado anexo I
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody ApartadoAnexoI edit(
			@RequestBody ApartadoAnexoI apartadoAnexoI) {
		ApartadoAnexoI ab0473s00Aux = this.apartadoAnexoIService
				.update(apartadoAnexoI);
		ApartadoAnexoIController.logger
				.info("[PUT] : ApartadoAnexoI actualizado correctamente");
		return ab0473s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  apartadoAnexoI
	 *            the apartado anexo I
	 *
	 * @param apartadoAnexoI the apartado anexo I
	 *  Ab0473s00 Bean resultante del proceso de creacion.
	 * @return the apartado anexo I
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody ApartadoAnexoI add(
			@RequestBody ApartadoAnexoI apartadoAnexoI) {
		ApartadoAnexoI apartadoAnexoIAux = this.apartadoAnexoIService
				.add(apartadoAnexoI);
		ApartadoAnexoIController.logger
				.info("[POST] : ApartadoAnexoI insertado correctamente");
		return apartadoAnexoIAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  apdoanx073
	 *            String Identificador del objeto que se desea eliminar.
	 *
	 * @param apdoanx073 the apdoanx 073
	 *  Ab0473s00 Bean eliminado.
	 * @return the apartado anexo I
	 */
	@RequestMapping(value = "/{apdoanx073}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody ApartadoAnexoI remove(
			@PathVariable String apdoanx073) {
		ApartadoAnexoI apartadoAnexoI = new ApartadoAnexoI();
		apartadoAnexoI.setApdoanx073(apdoanx073);
		this.apartadoAnexoIService.remove(apartadoAnexoI);
		ApartadoAnexoIController.logger
				.info("[DELETE] : ApartadoAnexoI borrado correctamente");
		return apartadoAnexoI;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		ApartadoAnexoIController.logger.info("[GET - View] : ApartadoAnexoI");
		return "apartadoanexoI";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterApartadoAnexoI
	 *            the filter apartado anexo I
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterApartadoAnexoI the filter apartado anexo I
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<Ab0473s00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<ApartadoAnexoI> filter(
			@RequestJsonBody(param = "filter") ApartadoAnexoI filterApartadoAnexoI,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ApartadoAnexoIController.logger
				.info("[POST - filter] : Obtener ApartadoAnexoI");
		return this.apartadoAnexoIService.filter(filterApartadoAnexoI,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterApartadoAnexoI
	 *            the filter apartado anexo I
	 *  searchApartadoAnexoI
	 *            the search apartado anexo I
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterApartadoAnexoI the filter apartado anexo I
	 * @param searchApartadoAnexoI the search apartado anexo I
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<Ab0473s00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<ApartadoAnexoI>> search(
			@RequestJsonBody(param = "filter") ApartadoAnexoI filterApartadoAnexoI,
			@RequestJsonBody(param = "search") ApartadoAnexoI searchApartadoAnexoI,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ApartadoAnexoIController.logger
				.info("[POST - search] : Buscar ApartadoAnexoI");
		return this.apartadoAnexoIService.search(filterApartadoAnexoI,
				searchApartadoAnexoI, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterApartadoAnexoI
	 *            the filter apartado anexo I
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterApartadoAnexoI the filter apartado anexo I
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") ApartadoAnexoI filterApartadoAnexoI,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ApartadoAnexoIController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples ApartadoAnexoI");
		this.apartadoAnexoIService.removeMultiple(filterApartadoAnexoI,
				jqGridRequestDto, false);
		ApartadoAnexoIController.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 *  filterApartadoAnexoI
	 *            the filter apartado anexo I
	 *  jqGridRequestDto
	 *            JQGridRequestDto que contiene los parÃ¡mtros de configuraciÃ³n
	 *            propios del RUP_TABLE a aplicar en el filtrado.
	 *  modelMap
	 *            ModelMap
	 *  columns
	 *            String
	 *  request
	 *            HttpServletRequest
	 *
	 * @param filterApartadoAnexoI the filter apartado anexo I
	 * @param jqGridRequestDto the jq grid request dto
	 * @param modelMap the model map
	 * @param columns the columns
	 * @param request the request
	 *  ModelAndView
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport",
			"xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(
			@ModelAttribute() ApartadoAnexoI filterApartadoAnexoI,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<ApartadoAnexoI> listApartadoAnexoI = this.apartadoAnexoIService
				.findAllLike(filterApartadoAnexoI, jqGridRequestDto, false);

		// GENERAMOS EL FICHERO
		UtilidadesWar.generateReport(modelMap,
				Utilities.getLiteralMessage(this.messageSource,
						"excel.titulo.apartadoAnexoI"),
				columns, listApartadoAnexoI);

		// GeneraciÃ³n del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}
}
